<?php
/* --------------------------------------------------------------
 NamespaceConfigurationFinder.php 2020-04-16
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

namespace Gambio\Core\Configuration\Services;

use Gambio\Core\Configuration\ConfigurationFinder as ConfigurationFinderInterface;

/**
 * Class NamespaceConfigurationFinder
 * @package Gambio\Core\Configuration\Services
 */
class NamespaceConfigurationFinder implements ConfigurationFinderInterface
{
    /**
     * @var ConfigurationFinderInterface
     */
    private $configurationFinder;
    
    /**
     * @var string
     */
    private $namespace;
    
    
    /**
     * NamespaceConfigurationFinder constructor.
     *
     * @param ConfigurationFinderInterface $configurationFinder
     * @param string                       $namespace
     */
    public function __construct(ConfigurationFinderInterface $configurationFinder, string $namespace)
    {
        $this->configurationFinder = $configurationFinder;
        $this->namespace           = $namespace;
    }
    
    
    /**
     * @inheritDoc
     */
    public function get(string $key, string $default = null): ?string
    {
        $key = "{$this->namespace}/{$key}";
        
        return $this->configurationFinder->get($key) ?? $default;
    }
}